###########################################################################
#
#     fWJ摜 (Exif/RAW`)̏擾E\Tu[`
#
#                    2001-2005 Copyright (C) cachu <cachu@cachu.xrea.jp>
#
#
#     fWJŗpĂ Exif `ɂ̓Vb^[xiȂ
# BȅL^Ă܂B̏ǂނ߂̃Tu[`łB
# ܂ꕔ̋@ RAW `摜̏ǂނƂo܂B
#
#     ݂̂Ƃ3̃Tu[`pӂĂ܂Bꂼ̎g
#
#     %ExifInfo = &InquireExif( $FileName, [$out] );
#     &WriteExifTAG( FILE, $LANG, %ExifInfo );
#     &PrintExifInfo( FILE, $LANG, $FileName, [$out] );
#
#          %ExifInfo: Exif 񂪕ۑnbV
#             $LANG :  (p̏ꍇ en, {̏ꍇ ja)
#          $FileName: 摜t@C
#              $out : t@Cnh (ȗ)
#              FILE : o͂t@Cnh
#
# łB InquireExif ̓t@Cǂݍŏ̃^Oԍƒl
# ΉnbVԂ܂BWriteExifTAG  InquireExif ɂ
# ꂽnbVf[^Ƃ Exif Wo͂ɏo܂B
# Ō PrintExifInfo ͏2̍s𓯎ɍs܂BnbVf[^
# KvȂꍇɂ͍Ō̃Tu[`𗘗p邾ł悢ł傤B
#
#     {XNvg̕R[h EUC `肵Ă܂BR[hϊ
# vOŕR[hϊĂ{Iɂ͓삵܂AShift-JIS 
# ꍇAꕔ̕\܂B̑΍Ƃ jcode.pl 𗘗p܂B
# ̓Iɂ͂̃XNvg̍ŏ
#
#    require 'jcode.pl'
#
# ǉ܂BɃTu[` ExifReadTagInfo ŃRgAEgĂ
# LɂĂBɏo͂镶R[hϐ $code Œ`
# B$code ɗpłl 'euc', 'jis', 'sjis' łBȏŕ
# 邱ƂȂCӂ̕R[hŏo͂ł܂BIɂ Jcode.pm p
# UTF-8 T|[gƎv܂B
#
#     TIFF `̉摜ߍ܂ꂽ Exif ɊւĂ͂Ă܂A
# ݂̂Ƃ듮mF͂ƂĂ܂(茳ɂȂ)B܂AGPS f[^
# ȂǂׂẴ^OɊւă`FbNłĂ킯ł͂܂̂ŁA
# s܂AƊłB
#
#     ꕔ̃fWJ RAW t@Cf[^ǂݍ߂܂A܂قƂ
# `FbNĂ܂B
#
#     ݂̃o[Wł Exif 2.21 ̎dlƂɍ쐬Ă܂B
# {ꃁbZ[WɊւĂ Exif 2.1 茳ɎȂ 2.21 
# ͉p̂܂܂ƂȂĂ܂B
#
#     [J[m[gɊւR[h̓vOCƂĒǉ`ɂȂĂ܂B
# ExifInfo.pl ƓfBNg maker_note ƂfBNg
# ̉ɃvOCt@CuƂɂ胁[J[m[gǂݍނ
# \ɂȂ܂B[J[m[g͂[U[ǂݍ
# Tu[`쐬邱ƂɂΉ\łBڂ
#
#              http://cachu.xrea.jp/perl/index.html
#
#  ExifInfo.pl ̐QlɂĉB
#
#
#     TODO ƂĂ
#
#         E Exif 2.21 ̎dlɑΉ
#         E x߂
#                + ׂẴ^ȌɑΉ
#                + \̏Ԃlł悤ɂ
#         E RAW f[^ɑΉ (ꕔ͂łɑΉĂ܂)
#
# ƂȂ܂B
#
# ܂Aݖ̂̂
#
#     SLONG ̏
#     TAG 34856 (OECF)                     ̏
#     TAG 41484 (SpatialFrequencyResponse) ̏
#     TAG 41730 (CFA Pattern)              ̏
#     TAG 41995 (DeviceSettingDescription) ̏
#
# łB
#
#
# [XV]
#    E 2005/11/12 - MakerNote vOC̏̎dlύX
#                          IFD ɕ̏񂪖ߍ܂Ăꍇ
#                           @ύXBɂLmƃ~m^
#                           ̃[J[m[gvOC̓Abvf[gK{
#                  - Exif IDÁÄꗗ\ł悤ɂ
#    E 2005/07/04 - oȌC
#    E 2004/12/13 - Photoshop ̃f[^ǂݍ̃oOC
#                  - IFD  ASCII ̏̏C
#    E 2004/12/07 - IFD ̃oOC
#    E 2004/12/03 - Photoshop RAW vOC 2.3 ɑΉ
#    E 2004/11/30 - oȌC
#    E 2004/11/28 - ꕔ RAW f[^ɑΉ
#                         ݃`FbN DiMAGE 7i ̂
#    E 2004/09/03 - XML ɊւoOC
#    E 2004/09/01 - oOC
#    E 2004/08/15 - t@C\[X/V[^CvɊւ鏈̃oȌC
#    E 2004/08/09 - Nikon [J[m[gɑΉł悤ɏC
#                  - IFDRead ̏C
#    E 2004/08/06 - ꕔ̃[J[m[gɑΉł悤ɏC
#    E 2004/08/01 - [J[m[gvOCɂgeՂɏo
#                    悤ɂB
#                         ExifInfo.pl ҏW邱ƂȂΉ\ɂ
#    E 2004/07/10 - Photoshop CS ɖߍ܂ꂽf[^̏
#                    ̍ہAxቺ̑Ώ
#                  - R[h΍ (ۂɗpɂ̓Rg
#                    ͂Kv)
#    E 2004/06/20 - Photoshop CS ɖߍ܂ꂽf[^̏
#                  - APP1 f[^̏o(fobOp)
#    E 2004/06/13 - Photoshop CS ɖߍ܂ꂽf[^̏
#                        ܂sS
#    E 2004/05/16 - ^ÕnbVɃt@Cꂽ
#    E 2004/04/11 - Exif TAG ̐ݒ@ς
#                  - [J[m[gւ̑Ή̂߂̃R[hn߂
#                  - Exif 2.21 ɈꕔΉ (܂Sł͂Ȃ)
#    E 2004/03/13 - {ꃁbZ[W̒ǉ
#                        + ɔTu[`̈̎dlύX
#    E 2003/09/10 - oOC
#    E 2003/07/13 - Exif 2.2 ɑΉ
#                  - TIFF Ɋւ鏈ꂽ(܂ĂȂ)
#                  -  APEX lǉ
#                  - oOC ( thanks suguru sato l)
#    E 2003/05/27 - oOC
#    E 2003/03/27 -  (GetPicSize.pl ؂)
#

# Exif ǂݍŕWo͂ɏo
sub PrintExifInfo{
    my ( $out, $LANG, $IMG, $in ) = @_;
    my %ExifInfo;

    %ExifInfo = ();

    if( $in ){
	%ExifInfo = &InquireExif( $IMG, $in );
    }else{
	%ExifInfo = &InquireExif( $IMG );
    }

    &WriteExifTAG( $out, $LANG, %ExifInfo );
}

# Exif ǂݍ
sub InquireExif{
    my ( $IMG, $in ) = @_;
    my ( %SHT, %LNG );
    my ( $endian, $Exif_IFD, $GPS_IFD, $ITP_IFD, @IFDs, $IFD );
    my ( $buf, $i, $id, $ntag );
    my ( $EOI, $APP1, $length, $exif );
    my ( $dummy, $dummy1, $dummy2, $dummy3, $dummy4, @dummy );
    my ( $ENTRY, $PK, $TAG, $TYPE, $COUNT, $V_OFFSET );
    my ( %TYPE,%COUNT, %VAL );
    my ( $BYTE, $ASCII, $SHORT, $LONG, $RATIONAL, $UNDEFINED );
    my ( $SLONG, $SRATIONAL );
    my ( $ImageType, $HI, $LOW, $SOI, $offset, $TIFF_HEAD, $code );
    my ( $mark, $type1, $type2, $skip, @APP1, $MAKER_TOP );
    my ( $read_total, $cache, $cpos, $tpos, $inloop, $pos );
    my ( $NULL, %CC );
    local %ExifInfo;
    local ( %exif, %crs, %tiff, %xap, %aux );

    ( &ExifReadTagInfo ) unless ( $ExifTAGDesc );

    # constant value
    %SHT = ( 'II' => 'v', 'MM' => 'n' );
    %LNG = ( 'II' => 'V', 'MM' => 'N' );
    %CC  = ( 0 => '', 1 => 'Y', 2 => 'Cb', 3 => 'Cr', 
	     4 => 'R', 5 => 'G', 6 => 'B' );

    $NULL      = pack( "C", 0x00 );
    $BYTE      =  1;
    $ASCII     =  2;
    $SHORT     =  3;
    $LONG      =  4;
    $RATIONAL  =  5;
    $UNDEFINED =  7;
    $SLONG     =  9;
    $SRATIONAL = 10;

    # initial value
    %ExifInfo = ();
    %TYPE     = ();
    %COUNT    = ();
    %VAL      = ();
    $endian   = '';

    $Exif_IFD     = -1;
    $GPS_IFD      = -1;
    $ITP_IFD      = -1;
    @IFDs         = ();
    $ExifInfo{-1} = 0;
    ( $in eq '' ) and ( $in = 'IMG' );

    open( $in, $IMG ) || return;
    binmode($in);

    # read header
    read( $in, $buf, 2 );
    ( $HI, $LOW ) = unpack( "C2", $buf );
    if( $buf =~ /(II)/ || $buf =~ /(MM)/ ){
	$ImageType = 'TIFF';
	$TIFF_HEAD = 0;
	$endian    = $1;

	read( $in, $buf, 6 );
	( $dummy1, $offset ) = unpack( "$SHT{$endian}$LNG{$endian}", $buf );
	seek( $in, $offset, 0 );

    }elsif( $HI == 0xFF && $LOW == 0xD8 ){       # FFD8 ... SOI
	$TIFF_HEAD += 2;
	$ImageType = 'JPEG';
	read( $in, $buf, 4 );
	$TIFF_HEAD += 4;
	( $HI, $LOW, $length ) = unpack( "CCn", $buf );
	if( $HI != 0xFF ){
	    close( $in );
	    return %ExifInfo;
	}

	while( $LOW != 0xE1 ){                   # FFE1 ... APP1
	    if( $LO == 0xDA ){                   # FFDA ... Start of Stream
		close( $in );
		return %ExifInfo;
	    }

	    seek( $in, $length-2, 1 );
	    read( $in, $buf, 4 );
	    $TIFF_HEAD += $length - 2 + 4;
#	    $TIFF_HEAD += 4;
	    ( $HI, $LOW, $length ) = unpack( "CCn", $buf );

	    if( $HI != 0xFF ){
		close( $in );
		return %ExifInfo;
	    }
	}

	read( $in, $buf, 6 );
	$TIFF_HEAD += 6;
	( $exif, $dummy ) = unpack( "A4A2", $buf );

	unless( $exif =~ /Exif/i ){
	    close( $in );
	    return %ExifInfo;
	}

	read( $in, $buf, 2 );
	$endian = unpack( "A2", $buf );
	read( $in, $buf, 6 );
	( $dummy1, $offset ) = unpack( "$SHT{$endian}$LNG{$endian}", $buf );
	seek( $in, $TIFF_HEAD+$offset, 0 );

    }else{
	# RAW file check
	seek( $in, 0, 0 );
	read( $in, $buf, 15 );

	# KONICA-MINOLTA RAW
	if( $buf =~ /MRM/ ){
	    seek( $in, 8, 0 );
	    $TIFF_HEAD = 8;

	    while( read( $in, $buf, 4 ) ){
		if( $buf =~ /(PRD|WBG|RIF)/i ){
		    read( $in, $buf, 4 );
		    $buf = unpack( "N", $buf );
		    seek( $in, $buf, 1 );
		    $TIFF_HEAD += $buf + 8;

		}elsif( $buf =~ /TTW/i ){
		    read( $in, $buf, 4 );
		    $buf = unpack( "N", $buf );
		    $TIFF_HEAD += 8;
		    read( $in, $buf, 2 );
		    if( $buf =~ /(II)/ || $buf =~ /(MM)/ ){
			$endian = $1;
			read( $in, $buf, 6 );
			( $dummy1, $offset )
			    = unpack( "$SHT{$endian}$LNG{$endian}", $buf );
			seek( $in, $TIFF_HEAD+$offset, 0 );
		    }		    
		    last;

		}else{
		    close( $in );
		    return %ExifInfo;
		}
	    }

	# FUJIFILM CCD-RAW Version 2.01?
	}elsif( $buf =~ /FUJIFILMCCD-RAW/ ){
	    $TIFF_HEAD = 160;
	    seek( $in, $TIFF_HEAD, 0 );
	    read( $in, $buf, 2 );
	    if( $buf =~ /(II)/ || $buf =~ /(MM)/ ){
		$endian = $1;
		read( $in, $buf, 6 );
		( $dummy1, $offset )
		    = unpack( "$SHT{$endian}$LNG{$endian}", $buf );
		seek( $in, $TIFF_HEAD+$offset, 0 );
	    }
	}

    }

    # read 0th IFD
    $ExifInfo{-1}         = 1;
    $ExifInfo{'FileName'} = $IMG;
    read( $in, $buf, 2 );
    $ENTRY = unpack( $SHT{$endian}, $buf );

    for( $i = 0 ; $i < $ENTRY ; $i++ ){
	read( $in, $buf, 8 );
	$PK = "$SHT{$endian}$SHT{$endian}$LNG{$endian}";
	( $TAG, $TYPE, $COUNT ) = unpack( $PK, $buf );

	$TYPE{$TAG}  = $TYPE;
	$COUNT{$TAG} = $COUNT;
	read( $in, $VAL{$TAG}, 4 );

	$PK = "$LNG{$endian}";
	if( $TAG == 34665 ){
  	    $Exif_IFD = unpack( $PK, $VAL{$TAG} );
	    $Exif_IFD += $TIFF_HEAD;

	}elsif( $TAG == 34853 ){
	    $GPS_IFD = unpack( $PK, $VAL{$TAG} );
	    $GPS_IFD += $TIFF_HEAD;

	}elsif( $TAG == 40965 ){
	    $ITP_IFD = unpack( $PK, $VAL{$TAG} );
	    $ITP_IFD += $TIFF_HEAD;
	}

    }

    # Exif, GPS and Interoperability IFDs
    @IFDs = ( $Exif_IFD, $GPS_IFD, $ITP_IFD );
    for( $id = 0 ; $id < 3 ; $id++ ){
	$IFD = $IFDs[$id];
	next if ( $IFD < 0 );

	seek( $in, $IFD, 0 );
	read( $in, $buf, 2 );
	$ENTRY = unpack( $SHT{$endian}, $buf );

	for( $i = 0 ; $i < $ENTRY ; $i++ ){
	    read( $in, $buf, 8 );
	    $PK = "$SHT{$endian}$SHT{$endian}$LNG{$endian}";
	    ( $TAG, $TYPE, $COUNT ) = unpack( $PK, $buf );
	    $TAG += $id * 1000000;

	    $TYPE{$TAG}  = $TYPE;
	    $COUNT{$TAG} = $COUNT;
	    read( $in, $VAL{$TAG}, 4 );

	}
    }

    # convert TAG information
    foreach $TAG ( keys %TYPE ){
	$PK       = "$LNG{$endian}";

	if( $TYPE{$TAG} != $UNDEFINED ){

	    $ExifInfo{$TAG} = &IFDRead( $in, $TYPE{$TAG}, $COUNT{$TAG},
					$VAL{$TAG}, $TIFF_HEAD, $endian );


	}elsif( $TYPE{$TAG} == $UNDEFINED ){
	    $V_OFFSET = unpack( $PK, $VAL{$TAG} );
	    $ExifInfo{$TAG} = $VAL{$TAG};

	    $ExifInfo{$TAG} = "UNDEF: $V_OFFSET : $COUNT{$TAG}";

	    if( $TAG == 37500 && $COUNT{$TAG} <1 ){ $TAG=""; }  ###### yssh
	    if( $TAG == 37510 && $COUNT{$TAG} <1 ){ $TAG=""; }  ###### yssh
	    if( $TAG == 37500 ){
		$MAKER_TOP = $V_OFFSET + $TIFF_HEAD;
		seek( $in, $V_OFFSET+$TIFF_HEAD, 0 );
		read( $in, $buf, $COUNT{$TAG} );
		$ExifInfo{$TAG} = $buf;

		( $debug_write ) and ( print "BYTE:: $COUNT{$TAG}\n" );
#		&InquireMakerNote( $in, $endian, $buf, $TIFF_HEAD );

	    }elsif( $TAG == 37510 ){
		seek( $in, $V_OFFSET+$TIFF_HEAD, 0 );
		read( $in, $buf, 8 );
		$buf = unpack( "A8", $buf );
		if( $buf =~ /ASCII/i ){
		    $code = 'ascii';
		}elsif( $buf =~ /JIS/i ){
		    $code = 'jis';
		}elsif( $buf =~ /Unicode/i ){
		    $code = 'utf8';
		}else{
		    $code = 'undifined';
		}
		read( $in, $buf, $COUNT{$TAG}-8 );
		$buf =~ s/$NULL//g;
		$ExifInfo{$TAG} = $buf;

	    }elsif( $TAG == 36864 || $TAG == 40960 ){
		$ExifInfo{$TAG} = unpack( "A4", $VAL{$TAG} );

	    }elsif( $TAG == 37121 ){
		( $dummy1, $dummy2, $dummy3, $dummy4 ) 
		    = unpack( "C4", $VAL{$TAG} );
		$ExifInfo{$TAG} = "$CC{$dummy1}$CC{$dummy2}$CC{$dummy3}$CC{$dummy4}";

	    }elsif( $TAG == 41728 || $TAG == 41729 ){
		$V_OFFSET = substr( $VAL{$TAG}, 0, 1 );
		$offset = unpack( "b8", $V_OFFSET );
		$V_OFFSET = 0;
		for( $i = 0 ; $i < 8 ; $i++ ){
		    my $bit = substr( $offset, $i, 1 );
		    $V_OFFSET += $bit * 2**$i;
		}
		$ExifInfo{$TAG} = $V_OFFSET;
	    }
	}
    }

    if( $ExifInfo{37500} ){
	&InquireMakerNote( $in, $endian, $ExifInfo{37500},
			   $TIFF_HEAD, $MAKER_TOP );
    }


    if( $app1_2nd ){
	$cpos = 0;
	$tpos = 0;
	my $markFF = pack( "C", 0xFF );
	my $markE1 = pack( "C", 0xE1 );
	my $markE0 = pack( "C", 0xE0 );
	my $markD9 = pack( "C", 0xD9 );
	seek( $in, 0, 0 );

	( $read_total, $buf, $cache, $cpos, $tpos ) =
	    &ReadDataFromCache( $in, $buf, 2, $cache, $cache_size,
				$read_total, $cpos, $tpos );
	( $type1, $type2 ) = unpack( "CC", $buf );

	if( $type1 == 0xFF && $type2 == 0xD8 ){
	  JPEG: while( 1 ){
	      ( $read_total, $type1, $cache, $cpos, $tpos ) =
		  &ReadDataFromCache( $in, $buf, 1, $cache, $cache_size,
				      $read_total, $cpos, $tpos );
	      ( last JPEG ) if ( $read_total == 0 );

	      if( $type1 eq $markFF ){
		  ( $read_total, $buf, $cache, $cpos, $tpos ) =
		      &ReadDataFromCache( $in, $buf, 1, $cache, $cache_size,
					  $read_total, $cpos, $tpos );
		  ( last JPEG ) if ( $read_total == 0 );

		  $type2 = unpack( "C", $buf );
		  if( $type2 == 0xD9 ){
		      last JPEG;

		  }elsif( $type2 == 0xD0 || $type2 == 0xD1 ||
			  $type2 == 0xD2 || $type2 == 0xD3 ||
			  $type2 == 0xD4 || $type2 == 0xD5 ||
			  $type2 == 0xD6 || $type2 == 0xD7 ||
			  $type2 == 0x01 ||
			  $type2 == 0xDA  ){

		      ( $read_total, $buf, $cache, $cpos, $tpos ) =
			  &ReadDataFromCache( $in, $buf, 2, $cache, 
					      $cache_size,
					      $read_total, $cpos, $tpos );
		      ( last JPEG ) if ( $read_total == 0 );

		      $skip = unpack( "n", $buf );
		      if( $type2 == 0xDA ){
			  $buf = substr( $cache, $cpos, $read_total - $cpos );
			  until( $buf =~ /$markFF($markE0|$markE1|$markD9)/ ){
			      ( $read_total, $buf, $cache, $cpos, $tpos ) =
				  &ReadDataFromCache( $in, $buf, $cache_size,
						      $cache, $cache_size,
						      $read_total, $cpos, $tpos );
			      ( last JPEG ) if ( $read_total == 0 );
			  }
			  if( $buf =~ /$markFF$markD9/ ){
			      last JPEG;
			  }
			  
			  $cpos = 0;
		      }

		      
		  }else{
		      ( $read_total, $buf, $cache, $cpos, $tpos ) =
			  &ReadDataFromCache( $in, $buf, 2, $cache,
					      $cache_size,
					      $read_total, $cpos, $tpos );
		      ( last JPEG ) if ( $read_total == 0 );

		      $skip = unpack( "n", $buf );
		      if( $type2 == 0xE1 ){
			  ( $read_total, $buf, $cache, $cpos, $tpos ) =
			      &ReadDataFromCache( $in, $buf, $skip-2,
						  $cache, $cache_size,
						  $read_total, $cpos, $tpos );
			  ( last JPEG ) if ( $read_total == 0 );
			  if( $buf =~ /x:xmpmeta/ ){
#print STDERR "$skip ::\n$buf\n";
			      $buf =~ s/</\n</g;
			      $buf =~ s/>/>\n/g;
			      $buf =~ s/\n\s*\n/\n/g;
			      $buf =~ s/\n\n/\n/g;
			      @APP1 = split( /\n/, $buf );
			      &ReadPhotoShopCS( @APP1 );
			  }else{
			      if( $maker_note ){
				  my $app1 = $ExifInfo{FileName};
				  $app1 =~ s/\.[^\.]+$/\.app1/;
				  open( APP1, ">$app1" );
				  print APP1 $buf;
				  close( APP1 );
			      }
			      next;
			  }
		      }else{
			  ( $read_total, $buf, $cache, $cpos, $tpos ) =
			      &ReadDataFromCache( $in, $buf, $skip-2,
						  $cache, $cache_size,
						  $read_total, $cpos, $tpos );
			  ( last JPEG ) if ( $read_total == 0 );
		      }
		  }
	      }
	  }
	}
    }
    close($in);
    return %ExifInfo;
}

# LbV𗘗păf[^ǂ
sub ReadDataFromCache{
    my ( $IN, $buf, $byte, $cache, $cache_size,
	 $read_total, $cpos, $tpos ) = @_;
    my ( $id, $cache_rest, $ntimes, $i, $byte_rest );

    $buf       = '';
    $byte_rest = $byte;
    $read_total = length( $cache );

    if( $cpos + $byte > $read_total ){
	$cache_rest = $read_total - $cpos;
	$ntimes = int( ( $byte - $cache_rest ) / $cache_size );
	$buf = substr( $cache, $cpos, $cache_rest );
	$tpos += $cache_rest;
	$byte_rest -= $cache_rest;
	for( $i = 0 ; $i < $ntimes ; $i++ ){
	    $read_total = read( $IN, $cache, $cache_size );
	    if( $read_total == 0 ){
		return ( $read_total, $buf, $cache, $cpos, $tpos );
	    }

	    $buf = $buf . $cache;
	    $tpos += $read_total;
	    $byte_rest -= $read_total;
	}

	$read_total = read( $IN, $cache, $cache_size );
	if( $read_total == 0 ){
	    return ( $read_total, $buf, $cache, $cpos, $tpos );
	}
	$cpos = 0;
    }

    ( $byte_rest > $read_total ) and ( $byte_rest = $read_total );

    $buf  .= substr( $cache, $cpos, $byte_rest );
    $cpos += $byte_rest;
    $tpos += $byte_rest;

    return ( $read_total, $buf, $cache, $cpos, $tpos );
}

# PhotoShop ɖߍ܂ꂽ XML f[^ǂ
sub ReadPhotoShopCS{
    local ( @APP1 ) = @_;
    my ( $app1, $napp1, $i, $j, $key );
    my ( $crs, $crstag, $exif, $tiff, $xap, $aux, $auxtag );

    $napp1 = @APP1;

    for( $i = 0 ; $i < $napp1 ; $i++ ){
	$_ = $APP1[$i];
	if( /<([^!:]?\w+):([^\s>]+)>*/ ){
	    $tag = $1;
	    $key = $2;
#	    print "HOGE:: $tag :: $key\n";

	    $j = &ReadXMLTag( $tag, $key, $i+1, $napp1, '', '' );
	    $i = $j;
	}
    }

    ( $debug_write ) and ( print "\n" );
    foreach $crs ( keys %crs ){
	$crstag = "CRS$crs";
	$ExifInfo{$ExifName{$crstag}} = $crs{$crs};
	( $debug_write ) and ( print " CRS:: $ExifName{$crstag} :: $crs :: $crs{$crs}\n" );
    }
    foreach $exif ( keys %exif ){
	$ExifInfo{$ExifName{$exif}} = $exif{$exif};
	( $debug_write ) and ( print "Exif:: $ExifName{$exif} :: $exif :: $exif{$exif}\n" );
    }
    foreach $tiff ( keys %tiff ){
	$ExifInfo{$ExifName{$tiff}} = $tiff{$tiff};
	( $debug_write ) and ( print "TIFF:: $ExifName{$tiff} :: $tiff :: $tiff{$tiff}\n" );
    }
    foreach $xap ( keys %xap ){
	$ExifInfo{$ExifName{$xap}} = $xap{$xap};
	( $debug_write ) and ( print " XAP:: $ExifName{$xap} :: $xap :: $xap{$xap}\n" );
    }
    foreach $aux ( keys %aux ){
	$auxtag = "CRS$aux";
	$ExifInfo{$ExifName{$auxtag}} = $aux{$aux};
	( $debug_write ) and ( print " AUX:: $ExifName{$auxtag} :: $aux :: $aux{$aux}\n" );
    }
    ( $debug_write ) and ( print "\n" );

}

# ȈՓI XML ^Ȍ
sub ReadXMLTag{
    my ( $tag, $key, $i, $napp1, $ptag, $pkey ) = @_;
    my ( $j, $k, $tag2, $key2 );

    for( $j = $i ; $j < $napp1 ; $j++ ){
	$_ = $APP1[$j];
	if( /<\/$tag\:$key>/ ){
	    return $j;

	}elsif( /<([^!:]+):([^\s>]+).*\/>/ ){
	    # PƂ̂̃^Ȍ݂͌Ȃ
	    next;

	}elsif( /<([^!:]?\w+):([^\s>]+)>*/ ){
	    $tag2 = $1;
	    $key2 = $2;
	    if( $ptag ){
		$k = &ReadXMLTag( $tag2, $key2, $j+1, $napp1, "$ptag\->$tag", "$pkey\->$key" );
	    }else{
		$k = &ReadXMLTag( $tag2, $key2, $j+1, $napp1, "$tag", "$key" );
	    }
	    $j = $k;

	}else{
	    ( $debug_write ) and ( print "VALUE: $tag :: $key :: $_ ( $ptag :: $pkey )\n" );

	    if( $tag eq 'rdf' ){
		if( $ptag =~ /exif/ && $pkey =~ /ISOSpeedRatings/ ){
		    $exif{ISOSpeedRatings} = $_;
		}else{
		    next;
		}
	    }

	    if( $ptag =~ /exif/ && $pkey =~ /Flash/ ){
		if( $key eq 'Fired' ){
		    ( $_ eq 'False' ) ? ( $exif{Flash} += 0 ) : ( $exif{Flash} += 1 );
		}elsif( $key eq 'Return' ){
		    # Ԃ񂱂łƎvc
		    $exif{Flash} += $_ * 2;
		}elsif( $key eq 'Mode' ){
		    # Ԃ񂱂łƎvc
		    $exif{Flash} += $_ * 8;
		}elsif( $key eq 'Function' ){
		    ( $_ eq 'False' ) ? ( $exif{Flash} += 0 ) : ( $exif{Flash} += 32 );
		}elsif( $key eq 'RedEyeMode' ){
		    ( $_ eq 'False' ) ? ( $exif{Flash} += 0 ) : ( $exif{Flash} += 64 );
		}
		next;
	    }
	    $ {$tag}{$key} = $_;
	}
    }
}

# [J[m[gǂ
sub InquireMakerNote{
    my ( $in, $endian, $notes, $TIFF_HEAD, $MAKER_TOP ) = @_;
    my ( $buf, $maker, $subname, $i, $num );

    $num = @ExifMaker;

    $buf = substr( $notes, 0, 8 );
    for( $i = 0 ; $i < $num ; $i++ ){
	if( $ExifMakerKey[$i] =~ /\S/ && $buf =~ /$ExifMakerKey[$i]/ ){
	    $subname = sprintf( "Inquire_%s_MakerNote", $ExifSubKey[$i] );
	    &$subname( $in, $notes, $endian, $TIFF_HEAD,
		       $ExifMakerID[$i], $ExifMakerABBR[$i], $MAKER_TOP );
	    return;
	}
    }

    for( $i = 0 ; $i < $num ; $i++ ){
	if( $ExifModel[$i] ne '' && $ExifInfo{272} =~ /$ExifModel[$i]/i ){
	    $subname = sprintf( "Inquire_%s_MakerNote", $ExifSubKey[$i] );
	    &$subname( $in, $notes, $endian, $TIFF_HEAD,
		       $ExifMakerID[$i], $ExifMakerABBR[$i], $MAKER_TOP );
	    return;
	}
    }
    return;

}

# IFD f[^̏
sub IFDRead{
    my ( $IO, $type, $count, $value, $head, $endian ) = @_;
    my ( $BYTE, $ASCII, $SHORT, $LONG, $RATIONAL, $UNDEFINED );
    my ( $SBYTE, $FLOAT, $DOUBLE );
    my ( $SSHORT, $SLONG, $SRATIONAL );
    my ( $NULL, $PK, $OutData, $buf, @dummy );
    my ( $i, $j, $dummy1, $dummy2, $bit );

    @dummy = ();
    $NULL = pack( "C", 0x00 );

    %SHT = ( 'II' => 'v', 'MM' => 'n' );
    %LNG = ( 'II' => 'V', 'MM' => 'N' );

    $BYTE      =  1;
    $ASCII     =  2;
    $SHORT     =  3;
    $LONG      =  4;
    $RATIONAL  =  5;
    $SBYTE     =  6;
    $UNDEFINED =  7;
    $SSHORT    =  8;
    $SLONG     =  9;
    $SRATIONAL = 10;
    $FLOAT     = 11;
    $DOUBLE    = 12;

    $PK = "$LNG{$endian}";

    if( $type == $ASCII ){
	if( $count > 4 ){
	    $offset = unpack( $PK, $value );
	    seek( $IO, $offset + $head, 0 );
	    read( $IO, $OutData, $count - 1 );
	}else{
	    $OutData = substr( $value, 0, $count-1 );
	}
#	$OutData =~ s/$NULL//g;
	$OutData =~ s/[^\x20-\x7e]//g;
	$OutData =~ s/^\s*([^\s].*[^\s])\s*$/$1/;

    }elsif( $type == $UNDEFINED ){
	if( $count > 4 ){
	    $offset = unpack( $PK, $value );
	    seek( $IO, $offset + $head, 0 );
	    read( $IO, $OutData, $count );
	}else{
	    $OutData = substr( $value, 0, $count );
	}

    }elsif( $type == $BYTE || $type == $SBYTE ){
	if( $count > 4 ){
	    $offset = unpack( $PK, $value );
	    seek( $IO, $offset + $head, 0 );
	    read( $IO, $value, $count );
	}

	for( $j = 1 ; $j <= $count ; $j++ ){
	    $dummy1 = substr( $value, $j-1, 1 );
	    $offset = unpack( "b8", $dummy1 );
	    for( $i = 0 ; $i < 7 ; $i++ ){
		$bit = substr( $offset, $i, 1 );
		$dummy[$j-1] += $bit * 2**$i;
	    }
	    $bit = substr( $offset, 7, 1 );
	    if( $type == $BYTE ){
		$dummy[$j-1] += $bit * 128;
	    }else{
		( $bit == 1 ) and ( $dummy[$j-1] = - $OutData );
	    }
	}
	$OutData = join( ' ', @dummy );

    }elsif( $type == $SHORT ){
	$PK = "$SHT{$endian}";
	$offset = unpack( $PK, $value );
	if( $count == 1 ){
	    $OutData = $offset;
	}elsif( $count == 2 ){
	    @dummy = unpack( "${PK}2", $value );
	    $OutData = join( ' ', @dummy );
	}else{
	    seek( $IO, $offset + $head, 0 );
	    read( $IO, $buf, $count*2 );
	    @dummy = unpack( "$PK$count", $buf );
	    $OutData = join( ' ', @dummy );
	}

    }elsif( $type == $LONG ){
	$offset = unpack( $PK, $value );
	if( $count == 1 ){
	    $OutData = $offset;
	}else{
	    seek( $IO, $offset + $head, 0 );
	    read( $IO, $buf, $count*4 );
	    @dummy = unpack( "$PK$count", $buf );
	    $OutData = join( ' ', @dummy );
	}

    }elsif( $type == $RATIONAL ){
	$offset = unpack( $PK, $value );
	seek( $IO, $offset + $head, 0 );
	$OutData = '';
	for( $i = 1; $i <= $count ; $i++ ){
	    read( $IO, $buf, 8 );
	    ( $dummy1, $dummy2 ) = unpack( "$PK$PK", $buf );
	    if( $i > 1 ){ $OutData .= " , "; }
	    $OutData .= "$dummy1 / $dummy2";
	}

    }elsif( $type == $SRATIONAL ){
	$offset = unpack( $PK, $value );
	seek( $IO, $offset + $head, 0 );
	for( $i = 1; $i <= $count ; $i++ ){
	    read( $IO, $buf, 8 );
	    $PK = "$LNG{$endian}$LNG{$endian}";
	    ( $dummy1, $dummy2 ) = unpack( $PK, $buf );
	    $dummy1 = unpack( "l", pack( "l", $dummy1 ) );
	    $dummy2 = unpack( "l", pack( "l", $dummy2 ) );
	    if( $i > 1 ){ $OutData .= " , "; }
	    $OutData .= "$dummy1 / $dummy2";
	}

    }elsif( $type == $SSHORT ){
	$PK = "$SHT{$endian}";
	if( $count == 1 ){
	    $OutData = unpack( "s", pack( "s", $value ) );
	}elsif( $count == 2 ){
	    @dummy = unpack( "${PK}2", $value );
	    $dummy[0] = unpack( "s", pack( "s", $dummy[0] ) );
	    $dummy[1] = unpack( "s", pack( "s", $dummy[1] ) );
	    $OutData = join( ' ', @dummy );
	}else{
	    $offset = unpack( "$SHT{$endian}", $value );
	    seek( $IO, $offset + $head, 0 );
	    read( $IO, $value, $count*2 );
	    @dummy = unpack( "$PK$COUNT", $value );
	    for( $i = 0 ; $i < $count ; $i++ ){
		$dummy[$i] = unpack( "s", pack( "s", $dummy[$i] ) );
	    }
	    $OutData = join( ' ', @dummy );
	}

    }elsif( $type == $SLONG ){
	$offset = unpack( $PK, $value );
	if( $count == 1 ){
	    $OutData = unpack( "l", pack( "l", $offset ) );
	}else{
	    seek( $IO, $offset + $head, 0 );
	    for( $i = 0 ; $i < $count ; $i++ ){
		read( $IO, $buf, 4 );
		push( @dummy, unpack( "l", pack( "l", $buf ) ) );
	    }
	    $OutData = join( ' ', @dummy );
	}

    }else{
	$OutData = 'undefined';
    }

    return $OutData;
}

# Exif ^Oo͂
sub WriteExifTAG($$%){
    my ( $out, $LANG, %TAG ) = @_;
    my ( $APEX, @list, $val );
    my ( $ExifTAG, $lang, $MakerNote, $mid );

    if( $LANG =~ /ja/i ){
	$lang = 'ja';
    }else{
	$lang = 'en';
    }

    $ExifTAG = 'ExifTAG' . $lang;
    $mid     = 0;


    foreach $TAG ( sort { $a <=> $b } keys %TAG ){
	unless( $debug_write ){
	    next if( $TAG == 34665 );
	    next if( $TAG == 34853 );
	    next if( $TAG == 40965 );
	}
	unless( $TAG =~ /[^0-9\-]/ ){
	    next if( $TAG <=  0 );
	}else{
	    next if( $TAG eq 'FileName' );
	}
#	next if( $TAG <=  0 );

	if( $mid == 0 && $TAG > 3100000 ){
	    # APEX value
	    if( $TAG{33437} ){
		@list = split( /\//, $TAG{33437} );
		$val  = $list[0] / $list[1];
		if( $val ){
		    $APEX = sprintf("%4.1f",2. * log( $val ) / log( 2 ) );
		}
		printf $out ( "%45s :: %4.1f\n", "Aperture Value (APEX) ",
			      $APEX );
	    }

	    # Shutter Speed Value (APEX)
	    if( $TAG{33434} ){
		@list = split( /\//, $TAG{33434} );
		$val  = $list[0] / $list[1];
		if( $val ){
		    $APEX = sprintf("%4.1f", - log( $val ) / log( 2 ) );
		}
		printf $out ( "%45s :: %4.1f\n", "Shutter Speed Value (APEX) ", $APEX );
	    }


	    $mid = 1;
	    print $out "\n\n";
	    print $out "                               ";
	    print $out "==== MAKER NOTE INFORMATION ====\n";
	}

	if( $$ExifTAG{$TAG} ){
	    if( $TAG == 37500 ){
		if( $maker_note ){
		    $MakerNote = $TAG{FileName};
		    $MakerNote =~ s/\.[^\.]+$/\.makernote/;
		    if( $debug_write ){
			printf $out ("%45s (%6d) :: %s\n",
				     $$ExifTAG{$TAG}, $TAG, $MakerNote );
		    }else{
			printf $out ( "%45s :: %s\n", $$ExifTAG{$TAG}, $MakerNote );
		    }
		}
		open( MN, ">$MakerNote" );
		print MN $TAG{$TAG};
		close( MN );
		next;
	    }
	    if( $debug_write ){
		printf $out ("%45s (%12s) :: ", $$ExifTAG{$TAG},$TAG );
	    }else{
		printf $out ("%45s :: ", $$ExifTAG{$TAG} );
	    }
	    if( $ExifTAGDesc->{$lang}->{$TAG} ){
		if( $debug_write ){
		    print $out "$TAG{$TAG}\n";
		}else{
		    print $out "$ExifTAGDesc->{$lang}->{$TAG}->{$TAG{$TAG}}\n";
		}
	    }else{
		print $out "$TAG{$TAG}\n";
	    }
	}else{
	    printf $out ("%45d :: ", $TAG );
	    print $out "$TAG{$TAG}\n";
	}
    }

}

# Exif IFD ^ȎΉ\̓ǂݍ
sub ExifReadTagInfo{
    my ( $lang, $table, @table, $i, $nlang, $ExifTAG );
    my ( $program );
    my ( $MAKER, $MODEL, $KEYWORD, $SUBKEY, $ID, $ABBR, $FILE, $USE );

    $nlang = @lang;
    
    while( <DATA> ){
	s/\r?\n$//;
        next if ( /^\#/ );
        next unless ( /\S/ );

        if( /\<exiftag\>/i ){
            while( $table = <DATA> ){
		$table =~ s/\r?\n$//;
		&jcode'convert( \$table, 'euc' );
                chomp( $table );
                next if ( $table =~ /^\#/ );
                next unless ( $table =~ /\S/ );
                last if( $table =~ /\<\/exiftag\>/i );

                @table = split( /\|/, $table );
                for( $i = 0 ; $i < 5 ; $i++ ){
                    $table[$i] =~ s/(\s*)?(.*\S)(\s*)?$/$2/;
		    $tmp = $table[$i];
		    &jcode'convert( \$tmp, $code );
		    $table[$i] = $tmp;
                }

		$ExifName{$table[1]} = $table[0];
		for( $i = 0 ; $i < $nlang ; $i++ ){
		    $ExifTAG = 'ExifTAG' . $lang[$i];
		    $$ExifTAG{$table[0]} = $table[$i+2];
		}
            }
        }

        if( /\<exifval\>/i ){
            while( $table = <DATA> ){
		$table =~ s/\r?\n$//;
		&jcode'convert( \$table, 'euc' );
                chomp( $table );
                next if ( $table =~ /^\#/ );
                next unless ( $table =~ /\S/ );
                last if( $table =~ /\<\/exifval\>/i );

                @table = split( /\|/, $table );
                for( $i = 0 ; $i < 5 ; $i++ ){
                    $table[$i] =~ s/(\s*)?(.*\S)(\s*)?$/$2/;
		    $tmp = $table[$i];
		    &jcode'convert( \$tmp, $code );
		    $table[$i] = $tmp;
                }

		for( $i = 0 ; $i < $nlang ; $i++ ){
                    $ExifTAGDesc->{$lang[$i]}->{$table[0]}->{$table[1]} = $table[$i+2];
		}
            }
        }
    }

    # [J[m[g
    unless( -d $makernotedir ){
	$program = $0;
	$program =~ s/\/[^\/]+$//;
	$program =~ s/\\[^\\]+$//;
	$makernotedir = $program . '/' . $makernotedir;
	return unless( -d $makernotedir );
    }

    while( <$makernotedir/makernote.*> ){
	open( MK, $_ );
	$MAKER   = '';
	$MODEL   = '';
	$KEYWORD = '';
	$SUBKEY  = '';
	$ID      = '';
	$ABBR    = '';
	$FILE    = '';
	$USE     = '';
	MK: while( <MK> ){
	    s/\r?\n$//;
	    next if ( /^\#/ );
	    next unless ( /\S/ );

	    if( /<common>/i ){
		while( <MK> ){
		    s/\r?\n$//;
		    next if( /^\#/ );
		    next unless( /\S/ );
		    last if( /<\/common>/i );
		    ( $MAKER       = $1 ) if ( /MAKER\s*=\s*(.*)$/ );
		    ( $MODEL       = $1 ) if ( /MODEL\s*=\s*(.*)$/ );
		    ( $KEYWORD     = $1 ) if ( /KEYWORD\s*=\s*(.*)$/ );
		    ( $SUBKEY      = $1 ) if ( /SUBKEY\s*=\s*(.*)$/ );
		    ( $ID          = $1 ) if ( /ID\s*=\s*(.*)$/ );
		    ( $ABBR        = $1 ) if ( /ABBR\s*=\s*(.*)$/ );
		    ( $FILE        = $1 ) if ( /FILE\s*=\s*(.*)$/ );
		    ( $USE         = $1 ) if ( /USE\s*=\s*(.*)$/ );
		}
	    }

	    ( last MK ) unless( $USE =~ /yes/i );

	    if( /\<exiftag\>/i ){
		while( $table = <MK> ){
		    $table =~ s/\r?\n$//;
		    &jcode'convert( \$table, 'euc' );
		    chomp( $table );
		    next if ( $table =~ /^\#/ );
		    next unless ( $table =~ /\S/ );
		    last if( $table =~ /\<\/exiftag\>/i );

		    @table = split( /\|/, $table );
		    for( $i = 0 ; $i < 5 ; $i++ ){
			$table[$i] =~ s/(\s*)?(.*\S)(\s*)?$/$2/;
			$tmp = $table[$i];
			&jcode'convert( \$tmp, $code );
			$table[$i] = $tmp;
		    }

		    my ( $maker_id, $maker_sub_id ) = split( /:/, $table[0] );
		    if( $table[0] =~ /:/ ){
			$table[0] = $ID * 100000 + $maker_id . ':' . $maker_sub_id;
		    }else{
			$table[0] = $ID * 100000 + $table[0];
		    }
		    $ExifName{$table[1]} = $table[0];
		    for( $i = 0 ; $i < $nlang ; $i++ ){
			$ExifTAG = 'ExifTAG' . $lang[$i];
			$$ExifTAG{$table[0]} = $table[$i+2];
		    }
		}
	    }

	    if( /\<exifval\>/i ){
		while( $table = <MK> ){
		    $table =~ s/\r?\n$//;
		    &jcode'convert( \$table, 'euc' );
		    chomp( $table );
		    next if ( $table =~ /^\#/ );
		    next unless ( $table =~ /\S/ );
		    last if( $table =~ /\<\/exifval\>/i );

		    @table = split( /\|/, $table );
		    for( $i = 0 ; $i < 5 ; $i++ ){
			$table[$i] =~ s/(\s*)?(.*\S)(\s*)?$/$2/;
			$tmp = $table[$i];
			&jcode'convert( \$tmp, $code );
			$table[$i] = $tmp;
		    }

		    my ( $maker_id, $maker_sub_id ) = split( /:/, $table[0] );
		    if( $table[0] =~ /:/ ){
			$table[0] = $ID * 100000 + $maker_id . ':' . $maker_sub_id;
		    }else{
			$table[0] = $ID * 100000 + $table[0];
		    }
		    for( $i = 0 ; $i < $nlang ; $i++ ){
			$ExifTAGDesc->{$lang[$i]}->{$table[0]}->{$table[1]} = $table[$i+2];
		    }
		}
	    }
	}
	close( MK );

	if( $USE =~ /yes/i ){
	    if( -e "$makernotedir/$FILE" ){
		require "$makernotedir/$FILE";
		push( @ExifMaker, $MAKER );
		push( @ExifModel, $MODEL );
		push( @ExifMakerKey, $KEYWORD );
		push( @ExifSubKey, $SUBKEY );
		push( @ExifMakerID, $ID );
		push( @ExifABBR, $ABBR );

	    }
	}
    }

}

BEGIN{
    @lang         = ( 'ja', 'en' );
    $debug_write  = 0;
    $maker_note   = 0;
    $app1_2nd     = 1;
    $cache_size   = 16384;   # 16kB
    $makernotedir = 'maker_note';

    $NULL      = pack( "C", 0x00 );
    %CTYPE = (
	      1 => 'BYTE     ',
	      2 => 'ASCII    ',
	      3 => 'SHORT    ',
	      4 => 'LONG     ',
	      5 => 'RATIONAL ',
	      6 => 'N/A      ',
	      7 => 'UNDEFINED',
	      8 => 'SSHORT   ',
	      9 => 'SLONG    ',
              10 => 'SRATIONAL'
              );
    %SHT = ( 'II' => 'v', 'MM' => 'n' );
    %LNG = ( 'II' => 'V', 'MM' => 'N' );
}

1;

__DATA__


<exiftag>
# TAG | ABBR                        | JPN DESCRIPTION                | ENG DESCRIPTION
#------+-----------------------------+--------------------------------+-------------------
  256 | ImageWidth                  | 摜̕                       | Image width
  257 | ImageLength                 | 摜̍                     | Image height
  258 | BitsPerSample               | 摜̃rbg̐[             | Number of bits per component
  259 | Compression                 | k̎                     | Compression scheme
  262 | PhotometricInterpretation   | 摜\                       | Pixel composition
  270 | ImageDescription            | 摜^Cg                   | Image title
  271 | Make                        | 摜͋@̃[J[       | Manufacturer of image input equipment
  272 | Model                       | 摜͋@̃f         | Model of image input equipment
  273 | StripOffsets                | 摜f[^̃P[V       | Image data location
  274 | Orientation                 | 摜                       | Orientation of image
  277 | SamplesPerPixel             | R|[lg               | Number of components
  278 | RowsPerStrip                | XgbṽC         | Number of rows per strip
  279 | StripByteCounts             | Xgbṽf[^           | Bytes per compressed strip
  282 | XResolution                 | 摜̉̕𑜓x               | Image resolution in width direction
  283 | YResolution                 | 摜̍̉𑜓x             | Image resolution in height direction
  284 | PlanarConfiguration         | 摜f[^̕               | Image data arrangement
  296 | ResolutionUnit              | 摜̕ƍ̉𑜓x̒P   | Unit of X and Y resolution
  301 | TransferFunction            | ĐKJ[u             | Transfer function
  305 | CreatorTool                 | gp\tgEFA             | Software used
  306 | ModifyDate                  | t@CύX               | File change date and time
  315 | Artist                      | Җ                         | Person who created the image
  318 | WhitePoint                  | QƔF_̐FxWl         | White point chromaticity
  319 | PrimaryChromaticities       | F̐FxWl               | Chromaticities of primaries
  513 | JPEGInterchangeFormat       | JPEG  SOI ւ̃ItZbg     | Offset to JPEG SOI
  514 | JPEGInterchangeFormatLength | JPEG f[^̃oCg          | Offset to JPEG data
  529 | YCbCrCoefficients           | Fϊ}gNXW           | Color space transformation matrix coefficients
  530 | YCbCrSubSampling            | YCC ̉f\ (C̊Ԉ)   | Subsampling ration of Y to C
  531 | YCbCrPositioning            | YCC ̉f\ (Y  C ̈ʒu) | Y and C positioning
  532 | ReferenceBlackWhite         | QƍF_lƎQƔF_l     | Pair of black and white reference values

33432 | Copyright         | Be쌠/ҏW쌠      | Copyright holder
34665 | ExifIFDPointer    | Exif ^O                      | Exif IFD pointer
34853 | GPSInfoIFDPointer | GPS ^O                       | GPS IFD pointer

33434 | ExposureTime            | Io                         | Exposure time
33437 | FNumber                 | Fl                              | F number
34850 | ExposureProgram         | IovO                   | Exposure program
34852 | SpectralSensitivity     | XyNgx                   | Spectral sensitivity
34855 | ISOSpeedRatings         | ISO Xs[h[g               | ISO speed ratings
34856 | OECF                    | d֐                     | Optoelectric conversion factor
36864 | ExifVersion             | Exif o[W                  | Exif version
36867 | DateTimeOriginal        | 摜f[^̐           | Date and time of original data generation
36868 | MetadataDate            | fW^f[^̐         | Date and time of digital data generation
37121 | ComponentsConfiguration | eR|[lg̈Ӗ           | Meaning of each component
37122 | CompressedBitsPerPixel  | 摜k[h                   | Image compression mode
37377 | ShutterSpeedValue       | Vb^[Xs[h               | Shutter speed
37378 | ApertureValue           | il                           | Aperture
37379 | BrightnessValue         | Pxl                           | Brightness
37380 | ExposureBiasValue       | Io␳l                       | Exposure bias
37381 | MaxApertureValue        | Yŏ F l                  | Maximul lens aperture
37382 | SubjectDistance         | ʑ̋                       | Subject distance
37383 | MeteringMode            |                          | Metering mode
37384 | LightSource             |                              | Light source
37385 | Flash                   | tbV                       | Flash
37386 | FocalLength             | Yœ_                   | Lens focal length
37396 | SubjectArea             | Subject area                     | Subject area
37500 | MakerNote               | [J[m[g                   | Manufacturer note
37510 | UserComment             | [U[Rg                 | User comments
37520 | SubSecTime              | Date Time ̃TuZbN           | Date time subseconds
37521 | SubSecTimeOriginal      | Date Time Original ̃TuZbN  | Date time original subseconds
37522 | SubSecTimeDegitized     | Date Time Digitized ̃TuZbN | Date time digitized subseconds
40960 | FlashpixVersion         | ΉtbVsbNXo[W | Supported Flashpix version
40961 | ColorSpace              | Fԏ                       | Color space information
40962 | PixelXDimension         | 摜                       | Valid image width
40963 | PixelYDimension         | 摜                     | Valid image height
40964 | RelatedSoundFile        | ֘At@C                 | Related audio file
40965 | InteroperabilityIFDPointer | ݊ IFD ւ̃|C^          | Interoperatibility IFD pointer
41483 | FlashEnergy             | tbVx                   | Flash energy
41484 | SpatialFrequencyResponse | Ԏg                   | Spatial frequency response
41486 | FocalPlaneXResolution    | œ_ʂ̉̕𑜓x               | Focal plane X resolution
41487 | FocalPlaneYResolution    | œ_ʂ̍̉𑜓x             | Focal plane Y resolution
41488 | FocalPlaneResolutionUnit | œ_ʉ𑜓xP                 | Focal plane resolution unit
41492 | SubjectLocation          | ʑ̈ʒu                       | SUbject location
41493 | ExposureIndex            | IoCfbNX                 | Exposure index
41495 | SensingMethod            | ZT[                     | Sensing method
41728 | FileSource               | t@C\[X                   | File source
41729 | SceneType                | V[^Cv                     | Scene type
41730 | CFAPattern               | CFA p^[                     | CFA psttern
41985 | CustomRendered           | JX^C[WvZbVO   | Custom image processing
41986 | ExposureMode             | Io[h                       | Exposure mode
41987 | WhiteBalance             | zCgoX                 | White balance
41988 | DigitalZoomRatio         | fW^Y[䗦               | Digital zoom ratio
41989 | FocalLengthIn35mmFilm    | 35mm Zœ_                | Focal length in 35mm film
41990 | SceneCaptureType         | V[Be^Cv                 | Scene capture type
41991 | GainControl              | QCRg[               | Gain control
41992 | Contrast                 | RgXg                     | Contrast
41993 | Saturation               | ʓx                             | Saturation
41994 | Sharpness                | V[vlX                     | Sharpness
41995 | DeviceSettingDescription | foCXݒ                     | Device settings description
41996 | SubjectDistanceRange     | ʑ͈̋                   | Subject distance range
42016 | 0xa420                   | j[N摜 ID                  | Unique image ID
42240 | 0xa500                   | K}l                         | Gamma

# DNG
50706 | DNGVersion               | DNG o[W                   | DNG version
50707 | DNGBackwardVersion       | DNG backward version             | DNG backward version
50708 | DNGUniqueCameraModel     | J@햼                     | Camera model
50709 | DNGLocalizedCameraModel  | J@햼                     | Localized camera model
50710 | DNGCFAPlaneColor         | CFA plane color                  | CFA plane color
50711 | DNGCFALayout             | CFA CAEg                   | CFA layout
50712 | DNGLinearizationTable    | Linearization table              | Linearization table
50713 | DNGBlackLevelRepeatDim   | Black level repeat dim           | Black level repeat dim
50714 | DNGBlackLevel            | Black level                      | Black level
50715 | DNGBlackLevelDeltaH      | Black level delta H              | Black level delta H
50716 | DNGBlackLevelDeltaV      | Black level delta V              | Black level delta V
50717 | DNGWhiteLevel            | White level                      | White level
50718 | DNGDefaultscale          | Default scale                    | Default scale
50719 | DNGDefaultCropOrigin     | Default crop origin              | Default crop origin
50720 | DNGDefaultCropSize       | Default crop size                | Default crop size
50721 | DNGColorMatrix1          | Color matrix1                    | Color matrix1
50722 | DNGColorMatrix2          | Color matrix2                    | Color matrix2
50723 | DNGCameraCalibration1    | Camera calibration1              | Camera calibration1
50724 | DNGCameraCalibration2    | Camera calibration2              | Camera calibration2
50725 | DNGReductionMatrix1      | Reduction matrix1                | Reduction matrix1
50726 | DNGReductionMatrix2      | Reduction matrix2                | Reduction matrix2
50727 | DNGAnalogBalance         | Analog balance                   | Analog balance
50728 | DNGAsShotNeutral         | As shot neutral                  | As shot neutral
50729 | DNGAsShotWhiteXY         | As shot white XY                 | As shot white XY
50730 | DNGBaselineExposure      | Baseline exposure                | Baseline exposure
50731 | DNGBaselineNoise         | Baseline noise                   | Baseline noise
50732 | DNGBaselineSharpness     | Baseline sharpness               | Baseline sharpness
50733 | DNGBayerGreenSplit       | Bayer green split                | Bayer green split
50734 | DNGLinearResponseLimit   | Linear response limit            | Linear response limit
50735 | DNGCameraSerialNumber    | VAio[                 | Camera serial number
50736 | DNGLensInfo              | Y                       | Lens information
50737 | DNGChromaBlurRadius      | Chroma blur radius               | Chroma blur radius
50738 | DNGAntiAliasStrength     | Anti-alias strength              | Anti-alias strength
50739 | DNGShadowScale           | Shadow scale                     | Shadow scale
50740 | DNGPrivateData           | vCx[gf[^               | Private data
50741 | DNGMakerNoteSafety       | MakerNote safety                 | MakerNote safety
50778 | DNGCalibrationIlluminant1 | Calibration illuminant1          | Calibration illuminant1
50779 | DNGCalibrationIlluminant2 | Calibration illuminant2          | Calibration illuminant2
50780 | DNGBestQualityScale      | Best quality scale               | Best quality scale
50781 | DNGRawDataUniqueID       | Raw data unique ID               | Raw data unique ID
50827 | DNGOriginalRawFileName   | IWi RAW t@C        | Original raw file name
50828 | DNGOriginalRawFileData   | IWi RAW t@Cf[^    | Original raw file data
50829 | DNGActiveArea            | Active area                      | Active area
50830 | DNGMaskedArea            | Masked area                      | Masked area
50831 | DNGAsShotICCProfile      | As shot ICC profile              | As shot ICC profile
50832 | DNGAsShotPreProfileMatrix | As shot pre-profile matrix      | As shot pre-profile matrix
50833 | DNGCurrentICCProfile     | Current ICC profile              | Current ICC profile
50834 | DNGCurrentPreProfileMatrix | Current pre-profile matrix     | Current re-profile matrix

# GPS
1000000 | GPSVersionID        | GPS ^Õo[W           | GPS tag version
1000001 | GPSLatitudeRef      | k(N) or (S)             | North or South latitude
1000002 | GPSLatitude         | ܓx (l)                    | Latitude
1000003 | GPSLongitudeRef     | o(E) or o(W)             | East or West longitude
1000004 | GPSLongitude        | ox (l)                    | Longitude
1000005 | GPSAltitudeRef      | x̒P                     | Altitude reference
1000006 | GPSAltitude         | x (l)                    | Altitude
1000007 | GPSTimeStamp        | GPS  (qv̎)      | GPS time (atomic clock)
1000008 | GPSSatellites       | ʂɎgqM           | GPS satellites used for measurement
1000009 | GPSStatus           | GPS M@̏               | GPS receiver status
1000010 | GPSMessureMode      | GPS ʕ@                   | GPS measurement mode
1000011 | GPSDOP              | ʂ̐M                   | Measurement precision
1000012 | GPSSpeedRef         | x̒P                     | Speed unit
1000013 | GPSSpeed            | x (l)                    | Speed of GPS receiver
1000014 | GPSTrackRef         | is̒P                 | Reference for direction of movement
1000015 | GPSTrack            | is (l)                | Direction of movement
1000016 | GPSImgDirectionRef  | Be摜̒̕P       | Reference for direction of image
1000017 | GPSImgDirection     | Be摜̕ (l)      | Direction of image
1000018 | GPSMapDatum         | ʗpn}f[^           | Geodetic survey data used
1000019 | GPSDestLatitudeRef  | ړIn̖k(N) or (S)     | Reference for latitude of destination
1000020 | GPSDestLatitude     | ړIn̈ܓx (l)            | Latitude of destination
1000021 | GPSDestLongitudeRef | ړIn̓o(E) or o(W)     | Reference for longitude of destination
1000022 | GPSDestLongitude    | ړIňox (l)            | Longitude of destination
1000023 | GPSDestBearingRef   | ړIn̕p̒P             | Reference for bearing of destination
1000024 | GPSDestBearing      | ړIn̕p (l)            | Bearing of destination
1000025 | GPSDestDistanceRef  | ړIn܂ł̋̒P         | Reference for distance to destination
1000026 | GPSDestDistance     | ړIn܂ł̋ (l)        | Distance to destination
1000027 | GPSProcessingMethod | Name of GPS processing method  | Name of GPS processing method
1000028 | GPSAreaInformation  | Name of GPS area               | Name of GPS area
1000029 | GPSDateStamp        | GPS date                       | GPS date
1000030 | GPSDifferential     | GPS differential correction    | GPS differential correction

2000000 | InteroperabilityIndex | ݊ʎq                   | Interoperatibility index

# Photoshop CS
3000001 | CRSRawFileName          | Raw t@C       | RawFileName
3000002 | CRSVersion              | o[W           | Version
3000003 | CRSWhiteBalance         | zCgoX     | WhiteBalance
3000004 | CRSTemperature          | Fx               | Temperature
3000005 | CRSTint                 | F               | Tint
3000006 | CRSShadowTint           | ShadowTint           | ShadowTint
3000007 | CRSExposure             | I               | Exposure
3000008 | CRSShadows              | VhE             | Shadows
3000009 | CRSBrightness           | 邳               | Brightness
3000010 | CRSContrast             | RgXg         | Contrast
3000011 | CRSSaturation           | ʓx                 | Saturation
3000012 | CRSRedSaturation        | ʓx()             | RedSaturation
3000013 | CRSGreenSaturation      | ʓx()             | GreenSaturation
3000014 | CRSBlueSaturation       | ʓx()             | BlueSaturation
3000015 | CRSSharpness            | V[v             | Sharpness
3000016 | CRSLuminanceSmoothing   | LuminanceSmoothing   | LuminanceSmoothing
3000017 | CRSRedHue               | RedHue               | RedHue
3000018 | CRSGreenHue             | GreenHue             | GreenHue
3000019 | CRSBlueHue              | BlueHue              | BlueHue
3000020 | CRSColorNoiseReduction  | ColorNoiseReduction  | ColorNoiseReduction
3000021 | CRSChromaticAberrationR | ChromaticAberrationR | ChromaticAberrationR
3000022 | CRSChromaticAberrationB | ChromaticAberrationB | ChromaticAberrationB
3000023 | CRSVignetteAmount       | VignetteAmount       | VignetteAmount
3000024 | CRSLens                 | Y               | Lens
3000025 | CRSSerialNumber         | VAio[     | Serial Number
3000026 | CRSAutoBrightness       | 邳ݒ       | Auto Brightness
3000027 | CRSAutoShadows          | VhEݒ     | Auto Shadows
3000028 | CRSAutoContrast         | RgXgݒ | Auto Contrast
3000029 | CRSAutoExposure         | Iʎݒ       | Auto Exposure
</exiftag>

<exifval>
  259 |     1 | 񈳏k                               | Uncompressed
  259 |     6 | JPEG k(TlĈ)            | JPEG compression (thumbnails only)

  262 |     2 | RGB                                  | RGB
  262 |     6 | YCbCr                                | YCbCr

  284 |     1 | _tH[}bg                   | Chunky format
  284 |     2 | ʏtH[}bg                   | Planar format

  531 |     1 | S                                 | Centerd
  531 |     2 | v                                 | Co-sited

  296 |     2 | C`                               | Inches
  296 |     3 | Z`[g                       | Centimeters

34850 |     0 | `                               | Not defined
34850 |     1 | }jA                           | Manual
34850 |     2 | m[}vO                   | Normal program
34850 |     3 | iD                             | Aperture priority
34850 |     4 | Vb^[D                       | Shutter priority
34850 |     5 | [xD                             | Creative program
34850 |     6 | X|[c                             | Action program
34850 |     7 | l                                 | Portrait mode
34850 |     8 | i                                 | Landscape mode

37383 |     0 | s                                 | Unknown
37383 |     1 |                                  | Average
37383 |     2 | d_                             | Center weighted average
37383 |     3 | X|bg                             | Spot
37383 |     4 | }`X|bg                       | Multi-spot
37383 |     5 |                              | Pattern
37383 |     6 |                              | Partial

37384 |     0 | s                                 | Unknown
37384 |     1 | z                               | Daylight
37384 |     2 | u                               | Fluorescent
37384 |     3 | ^OXe                         | Tungsten
37384 |     4 | tbV                           | Flash
37384 |     9 | V                                 | Fine weather
37384 |    10 | ܓV                                 | Cloudy weather
37384 |    11 | A                                 | Shade
37384 |    12 | Fu                         | Daylight fluorescent (D 5700 - 7100K)
37384 |    13 | Fu                         | Day white fluorescent (N 4600 - 5400K)
37384 |    14 | N[Fu                     | Cool white fluorescent (W 3900 - 4500K)
37384 |    15 | Fu                           | White fluorescent (WW 3200 - 3700K)
37384 |    17 | W A                             | Standard light A
37384 |    18 | W B                             | Standard light B
37384 |    19 | W C                             | Standard light C
37384 |    20 | D55                                  | D55
37384 |    21 | D65                                  | D65
37384 |    22 | D75                                  | D75
37384 |    23 | D50                                  | D50
37384 |    24 | ISO X^WId                     | ISO studio tungsten

37385 |     0 | 񔭌                               | Flash did not fire
37385 |     1 |                                  | Flash fired
37385 |     2 | ^[o                       | Strobe return light not detected
37385 |     3 | ^[o                         | Strobe return light detected
37385 |     5 | , ^[o                 | Strobe return light not detected
37385 |     7 | , ^[o                   | Strobe return light detected
37385 |     9 |                              | flash/compulsory
37385 |    13 | , ^[o             | flash/compulsory/no return
37385 |    15 | , ^[o               | flash/compulsory/return
37385 |    16 | ֎~                             | no flash/compulsory
37385 |    24 | 񔭌,                          | no flash/auto
37385 |    25 | ,                            | flash/auto
37385 |    29 | , , ^[o           | flash/auto/no return
37385 |    31 | , , ^[o             | flash/auto/return
37385 |    32 | tbV@\Ȃ                   | no function
37385 |    65 | , Ԗڌy                       | flash/red-eye
37385 |    69 | , Ԗڌy, ^[o       | flash/red-eye/no return
37385 |    71 | , Ԗڌy, ^[o         | flash/red-eye/return
37385 |    73 | , Ԗڌy                   | flash/compulsory/red-eye
37385 |    77 | , Ԗڌy, ^[o   | flash/compulsory/red-eye/no return
37385 |    79 | , Ԗڌy, ^[o     | flash/compulsory/red-eye/return
37385 |    89 | , , Ԗڌy                 | flash/auto/red-eye
37385 |    93 | , , Ԗڌy, ^[o | flash/auto/no return
37385 |    95 | , , Ԗڌy, ^[o   | flash/auto/red-eye/return

40961 |     1      | sRGB                                 | sRGB
40961 | 65535      | Adobe RGB                            | Uncalibrated
40961 | 4294967295 | Adobe RGB                            | Uncalibrated

41488 |     2 | C`                               | Inches
41488 |     3 | Z`[g                       | Centimeters

41495 |     1 | `                               | Not defined
41495 |     2 | PJ[ZT                     | One-chip color area sensor
41495 |     3 | 2J[ZT                      | Two-chip color area sensor
41495 |     4 | 3J[ZT                      | Three-chip color area sensor
41495 |     5 | FJ[ZT                   | Color sequential area sensor
41495 |     7 | 3jAZT                      | Trilinear sensor
41495 |     8 | FjAZT                   | Color sequential linear sensor

41728 |     0 | ̑                               | Others
41728 |     1 | ߌ^XL                       | Scanner of transparent type
41728 |     2 | ˎXL                       | Scanner of reflex type
41728 |     3 | DSC                                  | DSC

41729 |     1 | ڎBeꂽ摜                   | A directly photographed image

41985 |     0 | W                                 | Normal process
41985 |     1 | JX^                             | Custom process

41986 |     0 | Io                             | Auto exposure
41986 |     1 | }jAIo                       | Manual exposure
41986 |     2 | Auto Bracket                         | Auto bracket

41987 |     0 | zCgoX                 | Auto white balance
41987 |     1 | }jAzCgoX           | Manual white balance

41990 |     0 | W                                 | Standard
41990 |     1 | i                                 | Landscape
41990 |     2 | l                                 | Portrait
41990 |     3 | i                                 | Night scene

41991 |     0 | Ȃ                                 | None
41991 |     1 | Low gain up                          | Low gain up
41991 |     2 | High gain up                         | High gain up
41991 |     3 | Low gain down                        | Low gain down
41991 |     4 | High gain down                       | High gain down

41992 |     0 | W                                 | Normal
41992 |     1 | \tg                               | Soft
41992 |     2 | n[h                               | Hard

41993 |     0 | W                                 | Normal
41993 |     1 |                                    | Low saturation
41993 |     2 |                                    | High saturation

41994 |     0 | W                                 | Normal
41994 |     1 | \tg                               | Soft
41994 |     2 | n[h                               | Hard

41996 |     0 | s                                 | Unknown
41996 |     1 | }N                               | Macro
41996 |     2 | ߌi                                 | Close view
41996 |     3 | i                                 | Distant view

1000001 | N | k                                        | North latitude
1000001 | S |                                         | South latitude

1000003 | E | o                                        | East longitude
1000003 | W | o                                        | West longitude

1000005 | 0 | CW                                    | Sea level
1000005 | 1 | CW (̒l)                           | Sea level reference (negative value)

1000009 | A | ʒ                                      | Measurement in progress
1000009 | V |  (f)                             | Measurement interoperability

1000010 | 2 | 2ʒ                                 | 2-dimensional measurement
1000010 | 3 | 3ʒ                                 | 3-dimensional measurement

1000012 | K | L[g                                | Kilometers per hour
1000012 | M | }C                                      | Miles per hour
1000012 | N | mbg                                      | Knots

1000014 | T | ^                                      | True direction
1000014 | M | C                                    | Magnetic direction

1000016 | T | ^                                      | True direction
1000016 | M | C                                    | Magnetic direction

1000019 | N | k                                        | North latitude
1000019 | S |                                         | South latitude

1000021 | E | o                                        | East longitude
1000021 | W | o                                        | West longitude

1000023 | T | ^                                      | True direction
1000023 | M | C                                    | Magnetic direction

1000025 | K | L[g                                | Kilometers per hour
1000025 | M | }C                                      | Miles per hour
1000025 | N | C                                        | Knots

1000030 | 0 | Measurement without differential correction | Measurement without differential correction
1000030 | 1 | Differential correction applied             | Differential correction applied
</exifval>

